function []=STM32F103gplot(skt,update_rate,spawn)
%function []=dftest_RES(skt,update_rate,spawn)
% Version 2
% Ian Stothers 4 APR 2023
% Updated 14-June 2023  - only 1 call to sktopen

if(exist('skt')==0)
   skt.ip='192.168.1.4';
   ip=skt.ip;
else
  if (ischar(skt))
   ip=skt;
  else
   ip=skt.ip;
  endif
endif
if(exist('update_rate')==0)   update_rate=20; endif

if(exist('spawn')==0)
%function []=STM32F103gplot(skt,update_rate,spawn)
  callstr1= ["STM32F103gplot("...
  sprintf("\'%s\',",ip)...
  sprintf("%f,",update_rate)...
  sprintf("%d);",1)...
  ];
  octave_spawn(callstr1);
  return
else
  if (ischar(skt))
    skt=sktopen_noreg(skt);
  endif
endif


setenv('XDG_SESSION_TYPE','x11');


plotlen=1001;
tstep=1/update_rate;
Taxis=tstep*(0:(plotlen-1));

a=figure ("toolbar", "none");
set(a,'name',['STM32F103gplot.m IP - ' skt.ip]);
set(a,"numbertitle","off");

subplot(6,1,1);
r=STM32F103_get_result(skt);
R=r.sxy/r.sxx;
rfm=ones(1,plotlen)*abs(R);
rfa=ones(1,plotlen)*angle(R)*180/pi;
pfm=  plot(Taxis,rfm');
grid on
ylabel('Impedance Ohms');

pstrf=[ sprintf('Ohms = %5.3f  Angle = %3.3f    Coherence = %1.4f    Volts     %3.3f     Current   %3.3f ',abs(r.sxy/r.sxx),180*angle(r.sxy/r.sxx)/pi,r.Coherence,sqrt(abs(r.syy)),sqrt(abs(r.sxx)));
sprintf('Power(real) = %4.2fW   Power(imag) = %4.2fW  Frequency = %1.6f MHz',real(r.sxy), imag(r.sxy), r.CC_Fest/1e6);
];
ptf=title(pstrf);
subplot(6,1,2);
pfa=  plot(Taxis,rfa');
grid on
ylabel('Angle Degrees');

subplot(6,1,3);
rfp=ones(1,plotlen)*r.sxy;
pfpr=  plot(Taxis,real(rfp'));
grid on
ylabel('Real Power (W)');

subplot(6,1,4);
pfpi=  plot(Taxis,imag(rfp'));
grid on
ylabel('Imag Power (W)');

subplot(6,1,5);
rfc=ones(1,plotlen)*r.Coherence;
pfc=  plot(Taxis,rfc');
grid on
ylabel('Coherence');

subplot(6,1,6);
rff=ones(1,plotlen)*r.CC_Fest;
pff=  plot(Taxis,rff');
grid on
ylabel('Frequency (Hz)');

xlabel('Seconds');

tt=tic;
tp=toc(tt);
tstep=1/update_rate;

subplot(6,1,1);
try
  while (1)
   r=STM32F103_get_result(skt);
   R=r.sxy/r.sxx;
   rfm=[ abs(R) rfm(1:(end-1))];
   rfa=[ 180*angle(R)/pi rfa(1:(end-1))];
   rfp=[ r.sxy rfp(1:(end-1))];
   rfc=[ r.Coherence rfc(1:(end-1))];
   rff=[ r.CC_Fest rff(1:(end-1))];

   set(pfm,'ydata',rfm');
   set(pfa,'ydata',rfa');
   set(pfpr,'ydata',real(rfp)');
   set(pfpi,'ydata',imag(rfp)');
   set(pfc,'ydata',rfc');
   set(pff,'ydata',rff');
   pstrf=[ sprintf('Ohms = %5.3f  Angle = %3.3f    Coherence = %1.4f    Volts     %3.3f     Current   %3.3f ',abs(r.sxy/r.sxx),180*angle(r.sxy/r.sxx)/pi,r.Coherence,sqrt(abs(r.syy)),sqrt(abs(r.sxx)));
   sprintf('Power(real) = %4.2fW   Power(imag) = %4.2fW  Frequency = %1.6f MHz',real(r.sxy), imag(r.sxy), r.CC_Fest/1e6);
   ];
   set(ptf,'string',pstrf);
   tp=tp+tstep;
   while (toc(tt)<tp) pause(0.01); end
 end
catch
   %cleanup
   if(isfigure(a)==1) delete(a); end
   return;
end_try_catch

endfunction

